"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    startFhirWorker: function() {
        return startFhirWorker;
    },
    startFhirWorkerCommand: function() {
        return startFhirWorkerCommand;
    }
});
const _commander = require("commander");
const _logging = require("@tamanu/shared/services/logging");
const _ApplicationContext = require("../ApplicationContext");
const _tasks = require("../tasks");
const _packagejson = /*#__PURE__*/ _interop_require_default(require("../../package.json"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const startFhirWorker = async ({ name, skipMigrationCheck, topics })=>{
    _logging.log.info(`Starting Central FHIR worker version ${_packagejson.default.version}`);
    const appType = _ApplicationContext.CENTRAL_SERVER_APP_TYPES.FHIR_WORKER;
    const dbKey = name ? `${appType}(${name})` : appType;
    const context = await new _ApplicationContext.ApplicationContext().init({
        appType,
        dbKey
    });
    await context.store.sequelize.assertUpToDate({
        skipMigrationCheck
    });
    if (!topics || topics === 'all') {
        topics = null;
    } else {
        topics = topics.split(/,+\s*/).filter(Boolean);
        _logging.log.info(`FHIR worker restricted to topics: ${topics.join(', ')}`);
    }
    const worker = await (0, _tasks.startFhirWorkerTasks)({
        store: context.store,
        topics
    });
    for (const sig of [
        'SIGINT',
        'SIGTERM'
    ]){
        process.once(sig, async ()=>{
            _logging.log.info(`Received ${sig}, stopping fhir worker`);
            await worker.stop();
            context.close();
        });
    }
    await context.waitForClose();
};
const startFhirWorkerCommand = new _commander.Command('startFhirWorker').description('Start the Tamanu Central FHIR worker').option('--skipMigrationCheck', 'skip the migration check on startup').option('--topics <topics>', 'comma-separated topics to work on, defaults to all').action(startFhirWorker);

//# sourceMappingURL=startFhirWorker.js.map