"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "getLookupSourceTickRange", {
    enumerable: true,
    get: function() {
        return getLookupSourceTickRange;
    }
});
const _sequelize = require("sequelize");
const getLookupSourceTickRange = async ({ models }, pullSince, pullUntil)=>{
    const { SyncLookupTick } = models;
    const lookupTicks = await SyncLookupTick.findAll({
        where: {
            lookupEndTick: {
                [_sequelize.Op.gt]: pullSince,
                [_sequelize.Op.lt]: pullUntil
            }
        },
        order: [
            [
                'lookupEndTick',
                'ASC'
            ]
        ]
    });
    if (!lookupTicks.length) {
        return {};
    }
    const minSourceTick = lookupTicks.at(0).sourceStartTick;
    const maxSourceTick = lookupTicks.at(-1).lookupEndTick;
    return {
        minSourceTick,
        maxSourceTick
    };
};

//# sourceMappingURL=getLookupSourceTickRange.js.map