"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "BaseCommunicationProcessor", {
    enumerable: true,
    get: function() {
        return BaseCommunicationProcessor;
    }
});
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _tasks = require("@tamanu/shared/tasks");
const _logging = require("@tamanu/shared/services/logging");
const _files = require("../utils/files");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const maskMiddle = (s)=>s.slice(0, 1) + s.slice(1, -1).replace(/./g, '*') + s.slice(-1);
const maskEmail = (email)=>email.replace(/[^@]*/g, maskMiddle);
let BaseCommunicationProcessor = class BaseCommunicationProcessor extends _tasks.ScheduledTask {
    getName() {
        return this.constructor.name;
    }
    async countQueue() {
        const { PatientCommunication } = this.context.store.models;
        return PatientCommunication.countPendingMessages(this.channel);
    }
    async transformContent(emailRecord) {
        return emailRecord.content;
    }
    async run() {
        return this.processEmails();
    }
    async processEmails() {
        const { Patient, PatientCommunication } = this.context.store.models;
        const emailsToBeSent = await PatientCommunication.getPendingMessages(this.channel, {
            include: [
                {
                    model: Patient,
                    as: 'patient'
                }
            ],
            limit: this.config.limit
        });
        const sendEmails = emailsToBeSent.map((email)=>this.processEmail(email));
        return Promise.all(sendEmails);
    }
    async processEmail(email) {
        const emailPlain = email.get({
            plain: true
        });
        const toAddress = emailPlain.destination || emailPlain.patient?.email;
        _logging.log.info('Sending email to patient', {
            communicationId: emailPlain.id,
            type: emailPlain.type,
            patientId: emailPlain.patient?.id,
            email: toAddress ? maskEmail(toAddress) : null
        });
        const transformedContent = await this.transformContent(emailPlain);
        const result = await this.context.emailService.sendEmail({
            to: toAddress,
            from: _config.default.mailgun.from,
            subject: emailPlain.subject,
            text: transformedContent,
            attachment: emailPlain.attachment
        });
        return this.handleEmailResult(email, emailPlain, result);
    }
    async handleEmailResult(email, emailPlain, result) {
        if (result.error) {
            _logging.log.warn('Email failed', {
                communicationId: emailPlain.id,
                error: result.error
            });
        }
        if (result.shouldRetry) {
            return email.update({
                retryCount: emailPlain.retryCount + 1,
                error: result.error
            });
        }
        if (emailPlain.attachment) {
            await (0, _files.removeFile)(emailPlain.attachment);
        }
        return email.update({
            status: result.status,
            error: result.error
        });
    }
    constructor(context, configKey, channel){
        const conf = _config.default.schedules[configKey];
        const { schedule, jitterTime, enabled } = conf;
        super(schedule, _logging.log, jitterTime, enabled);
        this.config = conf;
        this.context = context;
        this.channel = channel;
    }
};

//# sourceMappingURL=BaseCommunicationProcessor.js.map