"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "ReportRequestScheduler", {
    enumerable: true,
    get: function() {
        return ReportRequestScheduler;
    }
});
const _constants = require("@tamanu/constants");
const _tasks = require("@tamanu/shared/tasks");
const _logging = require("@tamanu/shared/services/logging");
const _database = require("@tamanu/database");
let ReportRequestScheduler = class ReportRequestScheduler extends _tasks.ScheduledTask {
    getName() {
        return `ReportRequestScheduler for ${this.options.reportType}`;
    }
    async run() {
        const { reportType, recipients, parameters, requestedByUserId } = this.options;
        const newReportRequest = {
            reportType,
            recipients: JSON.stringify(recipients),
            parameters: JSON.stringify(parameters),
            status: _constants.REPORT_REQUEST_STATUSES.RECEIVED,
            requestedByUserId
        };
        await _database.ReportRequest.create(newReportRequest);
    }
    constructor(context, options){
        const { schedule, jitterTime, enabled } = options;
        super(schedule, _logging.log, jitterTime, enabled);
        this.context = context;
        this.options = options;
    }
};

//# sourceMappingURL=ReportRequestScheduler.js.map