"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
async function up(query) {
    await query.removeConstraint('patients', 'patients_merged_into_id_fkey');
    await query.removeConstraint('patient_additional_data', 'patient_additional_data_merged_into_id_fkey');
}
async function down(query) {
    await query.addConstraint('patients', {
        type: 'foreign key',
        name: 'patients_merged_into_id_fkey',
        fields: [
            'merged_into_id'
        ],
        references: {
            table: 'patients',
            field: 'id'
        }
    });
    await query.addConstraint('patient_additional_data', {
        type: 'foreign key',
        name: 'patient_additional_data_merged_into_id_fkey',
        fields: [
            'merged_into_id'
        ],
        references: {
            table: 'patient_additional_data',
            field: 'id'
        }
    });
}

//# sourceMappingURL=114_dropSelfReferencingConstraints.js.map