"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
async function up(query) {
    await query.sequelize.query(`
    CREATE TYPE fhir.annotation AS (
      authorReference fhir.reference,
      authorString    text,
      time            timestamptz,
      text            text
    );

    COMMENT ON TYPE fhir.annotation IS 'The text field of the annotation is required, and the author fields are mutually exclusive, but this is enforced in the application layer.';
  `);
}
async function down(query) {
    await query.sequelize.query(`DROP TYPE fhir.annotation`);
}

//# sourceMappingURL=1669241407944-fhirDatatypeAnnotation.js.map