"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = /*#__PURE__*/ _interop_require_wildcard(require("sequelize"));
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
async function up(query) {
    await query.createTable('sync_lookup', {
        id: {
            type: _sequelize.DataTypes.BIGINT,
            allowNull: false,
            primaryKey: true,
            autoIncrement: true
        },
        record_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false
        },
        record_type: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false
        },
        data: {
            type: _sequelize.DataTypes.JSON,
            allowNull: false
        },
        updated_at_sync_tick: {
            type: _sequelize.DataTypes.BIGINT,
            allowNull: false
        },
        patient_id: {
            type: _sequelize.default.STRING,
            allowNull: true
        },
        encounter_id: {
            type: _sequelize.default.STRING,
            allowNull: true
        },
        facility_id: {
            type: _sequelize.default.STRING,
            allowNull: true
        },
        is_lab_request: {
            type: _sequelize.default.BOOLEAN,
            allowNull: false
        },
        is_deleted: {
            type: _sequelize.default.BOOLEAN,
            allowNull: false
        },
        updated_at_by_field_sum: {
            type: _sequelize.DataTypes.BIGINT,
            allowNull: true
        }
    });
    await query.addConstraint('sync_lookup', {
        fields: [
            'record_id',
            'record_type'
        ],
        type: 'unique'
    });
}
async function down(query) {
    await query.dropTable('sync_lookup');
}

//# sourceMappingURL=1720675644781-addSyncLookupTable.js.map