"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
async function up(query) {
    await query.createTable('medication_administration_record_doses', {
        id: {
            type: _sequelize.DataTypes.UUID,
            allowNull: false,
            primaryKey: true,
            defaultValue: _sequelize.Sequelize.fn('gen_random_uuid')
        },
        dose_amount: {
            type: _sequelize.DataTypes.DECIMAL,
            allowNull: false
        },
        given_time: {
            type: _sequelize.DataTypes.DATETIMESTRING,
            allowNull: false
        },
        given_by_user_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false,
            references: {
                model: 'users',
                key: 'id'
            }
        },
        recorded_by_user_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false,
            references: {
                model: 'users',
                key: 'id'
            }
        },
        mar_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false,
            references: {
                model: 'medication_administration_records',
                key: 'id'
            }
        },
        dose_index: {
            type: _sequelize.DataTypes.INTEGER,
            allowNull: false
        },
        is_removed: {
            type: _sequelize.DataTypes.BOOLEAN,
            allowNull: true
        },
        reason_for_removal: {
            type: _sequelize.DataTypes.STRING,
            allowNull: true
        },
        reason_for_change: {
            type: _sequelize.DataTypes.STRING,
            allowNull: true
        },
        created_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: false,
            defaultValue: _sequelize.Sequelize.fn('now')
        },
        updated_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: false,
            defaultValue: _sequelize.Sequelize.fn('now')
        },
        deleted_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        }
    });
    await query.addIndex('medication_administration_record_doses', [
        'mar_id'
    ]);
    await query.addIndex('medication_administration_record_doses', [
        'dose_index'
    ]);
}
async function down(query) {
    await query.removeIndex('medication_administration_record_doses', [
        'dose_index'
    ]);
    await query.removeIndex('medication_administration_record_doses', [
        'mar_id'
    ]);
    await query.dropTable('medication_administration_record_doses');
}

//# sourceMappingURL=1742897789276-addMedicationAdministrationRecordDoseTable.js.map