"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
async function up(query) {
    await query.createTable('reference_medication_templates', {
        id: {
            type: _sequelize.DataTypes.UUID,
            primaryKey: true,
            defaultValue: _sequelize.Sequelize.fn('gen_random_uuid')
        },
        reference_data_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false,
            references: {
                model: 'reference_data',
                key: 'id'
            }
        },
        medication_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false,
            references: {
                model: 'reference_data',
                key: 'id'
            }
        },
        is_variable_dose: {
            type: _sequelize.DataTypes.BOOLEAN,
            allowNull: false,
            defaultValue: false
        },
        is_prn: {
            type: _sequelize.DataTypes.BOOLEAN,
            allowNull: false,
            defaultValue: false
        },
        dose_amount: {
            type: _sequelize.DataTypes.DECIMAL,
            allowNull: true
        },
        units: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false
        },
        frequency: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false
        },
        route: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false
        },
        duration_value: {
            type: _sequelize.DataTypes.DECIMAL,
            allowNull: true
        },
        duration_unit: {
            type: _sequelize.DataTypes.STRING,
            allowNull: true
        },
        notes: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: true
        },
        discharge_quantity: {
            type: _sequelize.DataTypes.INTEGER,
            allowNull: true
        },
        created_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: false,
            defaultValue: _sequelize.Sequelize.fn('now')
        },
        updated_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: false,
            defaultValue: _sequelize.Sequelize.fn('now')
        },
        deleted_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        }
    });
}
async function down(query) {
    await query.dropTable('reference_medication_templates');
}

//# sourceMappingURL=1746692718717-addReferenceMedicationTemplateTable.js.map