"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
async function up(query) {
    await query.sequelize.query(`
    CREATE OR REPLACE FUNCTION find_potential_patient_duplicates(
      patient_data JSON
    )
    RETURNS SETOF patients AS $$
    BEGIN      
      RETURN QUERY
      SELECT 
        p.*
      FROM 
        patients p
      WHERE 
        lower(p.first_name) = lower(patient_data->>'firstName') 
        AND lower(p.last_name) = lower(patient_data->>'lastName') 
        AND p.date_of_birth = patient_data->>'dateOfBirth'
        AND p.deleted_at IS NULL;
    END;
    $$ LANGUAGE plpgsql STABLE PARALLEL SAFE;
  `);
}
async function down(query) {
    await query.sequelize.query(`
    DROP FUNCTION IF EXISTS find_potential_patient_duplicates;
  `);
}

//# sourceMappingURL=1747692302917-addFindPotentialPatientDuplicatesFunction.js.map