"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const TABLE = {
    tableName: 'changes',
    schema: 'logs'
};
async function up(query) {
    await query.addColumn(TABLE, 'migration_context', {
        type: _sequelize.DataTypes.TEXT,
        allowNull: true
    });
    await query.sequelize.query(`
    CREATE OR REPLACE FUNCTION logs.record_change()
    RETURNS trigger AS $$
    BEGIN
      IF NOT logs.is_audit_changes_enabled() THEN
        RETURN NEW;
      END IF;

      INSERT INTO logs.changes (
        table_oid,
        table_schema,
        table_name,
        updated_by_user_id,
        record_id,
        device_id,
        version,
        reason,
        migration_context,
        record_created_at,
        record_updated_at,
        record_deleted_at,
        record_data
      ) VALUES (
        TG_RELID,                 -- table_oid
        TG_TABLE_SCHEMA,          -- table_schema
        TG_TABLE_NAME,            -- table_name
        get_session_config('${_constants.AUDIT_USERID_KEY}', uuid_nil()::text), -- updated_by_user_id
        NEW.id,                   -- record_id
        local_system_fact('${_constants.FACT_DEVICE_ID}', 'unknown'), -- device_id,
        local_system_fact('${_constants.FACT_CURRENT_VERSION}', 'unknown'), -- version,
        get_session_config('${_constants.AUDIT_REASON_KEY}', NULL), -- reason,
        get_session_config('${_constants.AUDIT_MIGRATION_CONTEXT_KEY}', NULL), -- migration_context,
        NEW.created_at,           -- created_at
        NEW.updated_at,           -- updated_at
        NEW.deleted_at,           -- deleted_at
        to_jsonb(NEW.*)           -- record_data
      );
      RETURN NEW;
    END;
    $$ LANGUAGE plpgsql;
    `);
}
async function down(query) {
    await query.removeColumn(TABLE, 'migration_context');
    await query.sequelize.query(`
    CREATE OR REPLACE FUNCTION logs.record_change()
    RETURNS trigger AS $$
    BEGIN
      IF NOT logs.is_audit_changes_enabled() THEN
        RETURN NEW;
      END IF;

      INSERT INTO logs.changes (
        table_oid,
        table_schema,
        table_name,
        updated_by_user_id,
        record_id,
        device_id,
        version,
        reason,
        record_created_at,
        record_updated_at,
        record_deleted_at,
        record_data
      ) VALUES (
        TG_RELID,                 -- table_oid
        TG_TABLE_SCHEMA,          -- table_schema
        TG_TABLE_NAME,            -- table_name
        get_session_config('${_constants.AUDIT_USERID_KEY}', uuid_nil()::text), -- updated_by_user_id
        NEW.id,                   -- record_id
        local_system_fact('${_constants.FACT_DEVICE_ID}', 'unknown'), -- device_id,
        local_system_fact('${_constants.FACT_CURRENT_VERSION}', 'unknown'), -- version,
        get_session_config('${_constants.AUDIT_REASON_KEY}', NULL), -- reason,
        NEW.created_at,           -- created_at
        NEW.updated_at,           -- updated_at
        NEW.deleted_at,           -- deleted_at
        to_jsonb(NEW.*)           -- record_data
      );
      RETURN NEW;
    END;
    $$ LANGUAGE plpgsql;
    `);
}

//# sourceMappingURL=1754948858420-addMigrationContextColumnToChangeLogs.js.map