"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "LabTestPanel", {
    enumerable: true,
    get: function() {
        return LabTestPanel;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
let LabTestPanel = class LabTestPanel extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            code: {
                type: _sequelize.DataTypes.STRING,
                allowNull: false
            },
            name: {
                type: _sequelize.DataTypes.STRING,
                allowNull: false
            },
            visibilityStatus: {
                type: _sequelize.DataTypes.STRING,
                defaultValue: _constants.VISIBILITY_STATUSES.CURRENT
            },
            externalCode: _sequelize.DataTypes.TEXT
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.PULL_FROM_CENTRAL
        });
    }
    static getListReferenceAssociations() {
        return [
            'category'
        ];
    }
    static initRelations(models) {
        this.belongsToMany(models.LabTestType, {
            through: models.LabTestPanelLabTestTypes,
            as: 'labTestTypes',
            foreignKey: 'labTestPanelId'
        });
        this.belongsTo(models.ReferenceData, {
            foreignKey: 'categoryId',
            as: 'category'
        });
    }
    static buildSyncFilter() {
        return null; // syncs everywhere
    }
    static async buildSyncLookupQueryDetails() {
        return null; // syncs everywhere
    }
};

//# sourceMappingURL=LabTestPanel.js.map