"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "PortalOneTimeToken", {
    enumerable: true,
    get: function() {
        return PortalOneTimeToken;
    }
});
const _sequelize = require("sequelize");
const _datefns = require("date-fns");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
const _model = require("../types/model");
let PortalOneTimeToken = class PortalOneTimeToken extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            type: {
                type: _sequelize.DataTypes.ENUM(..._constants.PORTAL_ONE_TIME_TOKEN_TYPE_VALUES),
                defaultValue: _constants.PORTAL_ONE_TIME_TOKEN_TYPES.LOGIN,
                allowNull: false
            },
            token: {
                type: _sequelize.DataTypes.STRING,
                allowNull: false
            },
            expiresAt: (0, _model.dateTimeType)('expiresAt', {
                allowNull: false
            })
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.DO_NOT_SYNC
        });
    }
    isExpired() {
        return (0, _datefns.isBefore)((0, _datefns.parseISO)(this.expiresAt), new Date());
    }
    static initRelations(models) {
        this.belongsTo(models.PortalUser, {
            foreignKey: {
                name: 'portalUserId',
                allowNull: false
            },
            as: 'portalUser'
        });
    }
};

//# sourceMappingURL=PortalOneTimeToken.js.map