import * as yup from 'yup';
import { FhirResource } from './Resource';
import type { InitOptions, Models } from '../../types/model';
import type { LabRequest } from '../../models/LabRequest';
export declare class FhirDiagnosticReport extends FhirResource {
    basedOn: {
        type: string;
        reference: string;
    }[];
    status: string;
    code: Record<string, any>;
    presentedForm?: {
        data: string;
        title: string;
        contentType: string;
    }[];
    static initModel(options: InitOptions, models: Models): void;
    static CAN_DO: Set<string>;
    static get INTAKE_SCHEMA(): import("yup/lib/object").OptionalObjectSchema<{
        basedOn: import("yup/lib/array").RequiredArraySchema<import("yup/lib/mixed").MixedSchema<any, import("yup/lib/types").AnyObject, any>, import("yup/lib/types").AnyObject, any[] | undefined>;
        status: import("yup/lib/string").RequiredStringSchema<string | undefined, import("yup/lib/types").AnyObject>;
        code: import("yup/lib/mixed").MixedSchema<any, import("yup/lib/types").AnyObject, any>;
        presentedForm: yup.ArraySchema<import("yup/lib/object").OptionalObjectSchema<{
            data: import("yup/lib/string").RequiredStringSchema<string | undefined, import("yup/lib/types").AnyObject>;
            title: import("yup/lib/string").RequiredStringSchema<string | undefined, import("yup/lib/types").AnyObject>;
            contentType: import("yup/lib/string").RequiredStringSchema<string | undefined, import("yup/lib/types").AnyObject>;
        }, import("yup/lib/object").AnyObject, import("yup/lib/object").TypeOfShape<{
            data: import("yup/lib/string").RequiredStringSchema<string | undefined, import("yup/lib/types").AnyObject>;
            title: import("yup/lib/string").RequiredStringSchema<string | undefined, import("yup/lib/types").AnyObject>;
            contentType: import("yup/lib/string").RequiredStringSchema<string | undefined, import("yup/lib/types").AnyObject>;
        }>>, import("yup/lib/types").AnyObject, import("yup/lib/object").TypeOfShape<{
            data: import("yup/lib/string").RequiredStringSchema<string | undefined, import("yup/lib/types").AnyObject>;
            title: import("yup/lib/string").RequiredStringSchema<string | undefined, import("yup/lib/types").AnyObject>;
            contentType: import("yup/lib/string").RequiredStringSchema<string | undefined, import("yup/lib/types").AnyObject>;
        }>[] | undefined, import("yup/lib/object").AssertsShape<{
            data: import("yup/lib/string").RequiredStringSchema<string | undefined, import("yup/lib/types").AnyObject>;
            title: import("yup/lib/string").RequiredStringSchema<string | undefined, import("yup/lib/types").AnyObject>;
            contentType: import("yup/lib/string").RequiredStringSchema<string | undefined, import("yup/lib/types").AnyObject>;
        }>[] | undefined>;
    }, import("yup/lib/object").AnyObject, import("yup/lib/object").TypeOfShape<{
        basedOn: import("yup/lib/array").RequiredArraySchema<import("yup/lib/mixed").MixedSchema<any, import("yup/lib/types").AnyObject, any>, import("yup/lib/types").AnyObject, any[] | undefined>;
        status: import("yup/lib/string").RequiredStringSchema<string | undefined, import("yup/lib/types").AnyObject>;
        code: import("yup/lib/mixed").MixedSchema<any, import("yup/lib/types").AnyObject, any>;
        presentedForm: yup.ArraySchema<import("yup/lib/object").OptionalObjectSchema<{
            data: import("yup/lib/string").RequiredStringSchema<string | undefined, import("yup/lib/types").AnyObject>;
            title: import("yup/lib/string").RequiredStringSchema<string | undefined, import("yup/lib/types").AnyObject>;
            contentType: import("yup/lib/string").RequiredStringSchema<string | undefined, import("yup/lib/types").AnyObject>;
        }, import("yup/lib/object").AnyObject, import("yup/lib/object").TypeOfShape<{
            data: import("yup/lib/string").RequiredStringSchema<string | undefined, import("yup/lib/types").AnyObject>;
            title: import("yup/lib/string").RequiredStringSchema<string | undefined, import("yup/lib/types").AnyObject>;
            contentType: import("yup/lib/string").RequiredStringSchema<string | undefined, import("yup/lib/types").AnyObject>;
        }>>, import("yup/lib/types").AnyObject, import("yup/lib/object").TypeOfShape<{
            data: import("yup/lib/string").RequiredStringSchema<string | undefined, import("yup/lib/types").AnyObject>;
            title: import("yup/lib/string").RequiredStringSchema<string | undefined, import("yup/lib/types").AnyObject>;
            contentType: import("yup/lib/string").RequiredStringSchema<string | undefined, import("yup/lib/types").AnyObject>;
        }>[] | undefined, import("yup/lib/object").AssertsShape<{
            data: import("yup/lib/string").RequiredStringSchema<string | undefined, import("yup/lib/types").AnyObject>;
            title: import("yup/lib/string").RequiredStringSchema<string | undefined, import("yup/lib/types").AnyObject>;
            contentType: import("yup/lib/string").RequiredStringSchema<string | undefined, import("yup/lib/types").AnyObject>;
        }>[] | undefined>;
    }>>;
    pushUpstream({ requesterId }: {
        requesterId: string;
    }): Promise<LabRequest>;
    getLabRequestStatus(): string;
    shouldUpdateLabRequestStatus(labRequest: LabRequest, newStatus: LabRequest['status']): boolean;
    saveAttachment(labRequest: LabRequest): Promise<void>;
}
//# sourceMappingURL=FhirDiagnosticReport.d.ts.map