"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "completeSyncSession", {
    enumerable: true,
    get: function() {
        return completeSyncSession;
    }
});
const _manageSnapshotTable = require("./manageSnapshotTable");
const completeSyncSession = async (store, sessionId, error)=>{
    // just drop the snapshots, leaving sessions themselves as an artefact that forms a paper trail
    const session = await store.models.SyncSession?.findByPk(sessionId);
    session.completedAt = new Date();
    if (error) {
        await session?.markErrored(error);
    }
    await session?.save();
    await (0, _manageSnapshotTable.dropSnapshotTable)(store.sequelize, sessionId);
    await (0, _manageSnapshotTable.dropMarkedForSyncPatientsTable)(store.sequelize, sessionId);
};

//# sourceMappingURL=completeSyncSession.js.map