"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    findSyncSnapshotRecords: function() {
        return findSyncSnapshotRecords;
    },
    findSyncSnapshotRecordsOrderByDependency: function() {
        return findSyncSnapshotRecordsOrderByDependency;
    }
});
const _case = require("case");
const _sequelize = require("sequelize");
const _manageSnapshotTable = require("./manageSnapshotTable");
const _getModelsForDirection = require("./getModelsForDirection");
const _sortInDependencyOrder = require("../utils/sortInDependencyOrder");
const findSyncSnapshotRecords = async ({ sequelize }, sessionId, direction, fromId = 0, limit = Number.MAX_SAFE_INTEGER, recordType, additionalWhere)=>{
    const tableName = (0, _manageSnapshotTable.getSnapshotTableName)(sessionId);
    const records = await sequelize.query(`
      SELECT * FROM ${tableName}
      WHERE true
      ${fromId ? 'AND id > :fromId' : ''}
      AND direction = :direction
      AND record_type = :recordType
      ${additionalWhere ? `AND ${additionalWhere}` : ''}
      ORDER BY id
      LIMIT :limit;
    `, {
        replacements: {
            fromId,
            recordType,
            direction,
            limit
        },
        type: _sequelize.QueryTypes.SELECT,
        raw: true
    });
    return records.map((r)=>Object.fromEntries(Object.entries(r).map(([key, value])=>[
                (0, _case.camel)(key),
                value
            ])));
};
const findSyncSnapshotRecordsOrderByDependency = async ({ sequelize, models }, sessionId, direction, fromId = '', limit = Number.MAX_SAFE_INTEGER, additionalWhere)=>{
    const tableName = (0, _manageSnapshotTable.getSnapshotTableName)(sessionId);
    const modelsForPull = (0, _getModelsForDirection.getModelsForPull)(models);
    const sortedModels = (0, _sortInDependencyOrder.sortInDependencyOrder)(modelsForPull);
    const { sortOrder: lastRecordTypeOrder, id: lastId } = fromId ? JSON.parse(atob(fromId)) : {};
    const records = await sequelize.query(`
      WITH priority(record_type, sort_order) AS (
        VALUES
          ${sortedModels.map((model, index)=>`('${model.tableName}', ${index + 1})`).join(',\n')}
      )
      SELECT * FROM ${tableName}
      JOIN priority ON ${tableName}.record_type = priority.record_type
      WHERE true
      ${lastRecordTypeOrder && lastId ? `AND (priority.sort_order, id) > (:lastRecordTypeOrder, :lastId)` : ''}
      AND direction = :direction
      ${additionalWhere ? `AND ${additionalWhere}` : ''}
      ORDER BY priority.sort_order, id
      LIMIT :limit;
    `, {
        replacements: {
            lastRecordTypeOrder,
            lastId,
            direction,
            limit
        },
        type: _sequelize.QueryTypes.SELECT,
        raw: true
    });
    return records.map((r)=>Object.fromEntries(Object.entries(r).map(([key, value])=>[
                (0, _case.camel)(key),
                value
            ])));
};

//# sourceMappingURL=findSyncSnapshotRecords.js.map