import { DataTypes } from 'sequelize';
export async function up(query) {
    // write your up migration here
    await query.createTable('imaging_type_external_codes', {
        id: {
            type: DataTypes.STRING,
            allowNull: false,
            primaryKey: true,
            defaultValue: DataTypes.UUIDV4
        },
        created_at: {
            type: DataTypes.DATE,
            defaultValue: DataTypes.NOW,
            allowNull: false
        },
        updated_at: {
            type: DataTypes.DATE,
            defaultValue: DataTypes.NOW,
            allowNull: false
        },
        deleted_at: {
            type: DataTypes.DATE,
            allowNull: true
        },
        visibility_status: {
            type: DataTypes.TEXT,
            allowNull: false,
            defaultValue: 'current'
        },
        imaging_type_code: {
            type: DataTypes.TEXT,
            allowNull: false
        },
        code: {
            type: DataTypes.TEXT,
            allowNull: false
        },
        description: {
            type: DataTypes.TEXT,
            allowNull: true
        }
    });
}
export async function down(query) {
    await query.dropTable('imaging_type_external_codes');
}

//# sourceMappingURL=1764202017939-AddImagingTypeExternalCodeTable.js.map