import { Model } from './Model';
import type { InitOptions, Models } from '../types/model';
import { ReadSettings } from '@tamanu/settings';
interface UserLoginAttemptMethodParams {
    settings: ReadSettings;
    userId: string;
    deviceId?: string;
}
export declare class UserLoginAttempt extends Model {
    id: string;
    outcome: string;
    userId: string;
    deviceId: string | null;
    static initModel(options: InitOptions): void;
    static initRelations(models: Models): void;
    static getDeviceIdToUse(deviceId: string): Promise<string | null>;
    static checkIsUserLockedOut({ settings, userId, deviceId, }: UserLoginAttemptMethodParams): Promise<{
        isUserLockedOut: boolean;
        remainingLockout: number;
    }>;
    static createFailedLoginAttempt({ settings, userId, deviceId, }: UserLoginAttemptMethodParams): Promise<{
        loginAttempt: UserLoginAttempt | null;
        lockoutDuration: number;
        remainingAttempts: number;
    }>;
}
export {};
//# sourceMappingURL=UserLoginAttempt.d.ts.map