function _define_property(obj, key, value) {
    if (key in obj) {
        Object.defineProperty(obj, key, {
            value: value,
            enumerable: true,
            configurable: true,
            writable: true
        });
    } else {
        obj[key] = value;
    }
    return obj;
}
import { DataTypes } from 'sequelize';
import { FHIR_INTERACTIONS } from '@tamanu/constants';
import { FhirResource } from './Resource';
import { fromFacilities, getQueryOptions, getValues, searchParameters } from '../../utils/fhir/Organization';
export class FhirOrganization extends FhirResource {
    static initModel(options, models) {
        super.initResource({
            identifier: DataTypes.JSONB,
            name: DataTypes.TEXT,
            active: DataTypes.BOOLEAN
        }, options);
        this.UpstreamModels = [
            models.Facility
        ];
        this.upstreams = [
            models.Facility
        ];
    }
    async updateMaterialisation() {
        const upstream = await this.getUpstream(getQueryOptions());
        const values = await getValues(upstream, this.sequelize.models);
        this.set(values);
    }
    static async queryToFindUpstreamIdsFromTable(upstreamTable, table, id) {
        const { Facility } = this.sequelize.models;
        if (upstreamTable === Facility.tableName) {
            return fromFacilities(this.sequelize.models, table, id);
        }
        return null;
    }
    static searchParameters() {
        return {
            ...super.searchParameters(),
            ...searchParameters
        };
    }
}
_define_property(FhirOrganization, "CAN_DO", new Set([
    FHIR_INTERACTIONS.INSTANCE.READ,
    FHIR_INTERACTIONS.TYPE.SEARCH,
    FHIR_INTERACTIONS.INTERNAL.MATERIALISE
]));

//# sourceMappingURL=FhirOrganization.js.map