import { DataTypes, Utils } from 'sequelize';
export * from './pgType';
export * from './sequelizeType';
export * from './stringifier';
/**
 * Register a new type with sequelize.
 * CANNOT register an extension of an existing sequelize type (like STRING, etc).
 * Only use with fully-new types.
 */ export function newPgDataType(Klass) {
    const name = Klass.key;
    DataTypes[name] = Utils.classToInvokable(Klass);
    DataTypes[name].types.postgres = [
        Klass.pgName
    ];
}

//# sourceMappingURL=index.js.map