"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "QuotaExceededError", {
    enumerable: true,
    get: function() {
        return QuotaExceededError;
    }
});
const _AuthenticationError = require("../AuthenticationError");
const _constants = require("../../constants");
let QuotaExceededError = class QuotaExceededError extends _AuthenticationError.BaseAuthenticationError {
    constructor(detail){
        super(_constants.ERROR_TYPE.AUTH_QUOTA_EXCEEDED, 'Device registration quota exceeded', detail);
        this.status = 401;
    }
};

//# sourceMappingURL=QuotaExceededError.js.map