"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "generateImportData", {
    enumerable: true,
    get: function() {
        return generateImportData;
    }
});
const _constants = require("@tamanu/constants");
const _index = require("../../fake/index.js");
const generateImportData = async ({ ReferenceData, ReferenceDataRelation, Facility, LocationGroup, Location, Department, Survey, SurveyScreenComponent, ScheduledVaccine, ProgramDataElement, Program, ProgramRegistry, ProgramRegistryCondition, ProgramRegistryClinicalStatus, InvoiceProduct, LabTestType, User })=>{
    const referenceData = await ReferenceData.create((0, _index.fake)(ReferenceData, {
        type: _constants.REFERENCE_TYPES.DRUG
    }));
    await ReferenceDataRelation.create((0, _index.fake)(ReferenceDataRelation));
    const facility = await Facility.create((0, _index.fake)(Facility));
    const locationGroup = await LocationGroup.create((0, _index.fake)(LocationGroup, {
        facilityId: facility.id
    }));
    const location = await Location.create((0, _index.fake)(Location, {
        facilityId: facility.id,
        locationGroupId: locationGroup.id
    }));
    const department = await Department.create((0, _index.fake)(Department, {
        facilityId: facility.id
    }));
    const survey = await Survey.create((0, _index.fake)(Survey));
    await SurveyScreenComponent.create((0, _index.fake)(SurveyScreenComponent, {
        surveyId: survey.id,
        option: '{"foo":"bar"}',
        config: '{"source": "ReferenceData", "where": {"type": "facility"}}'
    }));
    const scheduledVaccine = await ScheduledVaccine.create((0, _index.fake)(ScheduledVaccine, {
        vaccineId: referenceData.id
    }));
    await ProgramDataElement.create((0, _index.fake)(ProgramDataElement));
    const program = await Program.create((0, _index.fake)(Program));
    const programRegistry = await ProgramRegistry.create((0, _index.fake)(ProgramRegistry, {
        programId: program.id
    }));
    await ProgramRegistryCondition.create((0, _index.fake)(ProgramRegistryCondition, {
        programRegistryId: programRegistry.id
    }));
    await ProgramRegistryClinicalStatus.create((0, _index.fake)(ProgramRegistryClinicalStatus, {
        programRegistryId: programRegistry.id
    }));
    const invoiceProduct = await InvoiceProduct.create((0, _index.fake)(InvoiceProduct, {
        category: _constants.INVOICE_ITEMS_CATEGORIES.DRUG,
        sourceRecordType: _constants.INVOICE_ITEMS_CATEGORIES_MODELS[_constants.INVOICE_ITEMS_CATEGORIES.DRUG],
        sourceRecordId: referenceData.id
    }));
    const labTestType = await LabTestType.create((0, _index.fake)(LabTestType, {
        labTestCategoryId: referenceData.id
    }));
    const user = await User.create((0, _index.fake)(User));
    return {
        referenceData,
        facility,
        department,
        locationGroup,
        location,
        survey,
        scheduledVaccine,
        invoiceProduct,
        labTestType,
        user,
        programRegistry
    };
};

//# sourceMappingURL=importData.js.map