import { zocker } from 'zocker';
import { processMock } from './utils';
import { createEncounterSchema } from '@tamanu/shared/schemas/facility/requests/createEncounter.schema';
/**
 * Generates fake encounter request body data using the encounter schema
 * @param options - The options for creating the encounter
 * @returns Fake encounter request body data
 */ export const fakeCreateEncounterRequestBody = (options)=>{
    const { required, excludedFields = [], overrides = {} } = options;
    const mock = zocker(createEncounterSchema).generate();
    const final = {
        ...processMock({
            schema: createEncounterSchema,
            mock,
            excludedFields
        }),
        ...overrides,
        ...required
    };
    return final;
};

//# sourceMappingURL=createEncounter.js.map