"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    LOCALISED_FIELD_TYPES: function() {
        return LOCALISED_FIELD_TYPES;
    },
    displayIdFieldProperties: function() {
        return displayIdFieldProperties;
    },
    generateFieldSchema: function() {
        return generateFieldSchema;
    }
});
const _yup = /*#__PURE__*/ _interop_require_wildcard(require("yup"));
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
const LOCALISED_FIELD_TYPES = {
    DATE: 'date',
    NUMBER: 'number',
    STRING: 'string'
};
const generateFieldSchema = ({ isPatientDetails = false, hideable = true, type })=>{
    const schema = {
        required: {
            description: 'Field is required',
            type: _yup.boolean(),
            defaultValue: false
        },
        defaultValue: {
            description: 'Default value for field',
            type: _yup.mixed(),
            defaultValue: null
        }
    };
    if (hideable) {
        schema.hidden = {
            description: 'Field should not display on forms',
            type: _yup.boolean(),
            defaultValue: false
        };
    }
    if (isPatientDetails) {
        schema.requiredPatientData = {
            description: 'Field must be filled out when creating a patient',
            type: _yup.boolean(),
            defaultValue: false
        };
    }
    switch(type){
        case LOCALISED_FIELD_TYPES.STRING:
            schema.defaultValue.type = _yup.string().nullable();
            break;
        case LOCALISED_FIELD_TYPES.NUMBER:
            schema.defaultValue.type = _yup.number().nullable();
            break;
    }
    return schema;
};
const displayIdFieldProperties = {
    ...generateFieldSchema({
        hideable: false,
        type: LOCALISED_FIELD_TYPES.STRING
    }),
    pattern: {
        description: 'Regex to enforce the format of field input',
        type: _yup.string(),
        defaultValue: '[\\s\\S]*'
    }
};

//# sourceMappingURL=fields.js.map