"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "AppointmentSchema", {
    enumerable: true,
    get: function() {
        return AppointmentSchema;
    }
});
const _zod = require("zod");
const _referenceDataschema = require("./referenceData.schema");
const _userschema = require("./user.schema");
const _locationGroupschema = require("./locationGroup.schema");
const _constants = require("@tamanu/constants");
const AppointmentSchema = _zod.z.object({
    id: _zod.z.string(),
    // Appointment timing
    startTime: _zod.z.string(),
    endTime: _zod.z.string().nullish(),
    // Appointment details
    status: _zod.z.enum(_constants.APPOINTMENT_STATUSES),
    isHighPriority: _zod.z.boolean(),
    // Type information
    appointmentType: _referenceDataschema.ReferenceDataSchema.nullish(),
    // Location information
    locationGroup: _locationGroupschema.LocationGroupSchema.nullish(),
    // Clinician information
    clinician: _userschema.UserSchema.nullish()
});

//# sourceMappingURL=appointment.schema.js.map