import { z } from 'zod';
export declare const BaseSurveySchema: z.ZodObject<{
    id: z.ZodString;
    code: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    name: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    surveyType: z.ZodOptional<z.ZodNullable<z.ZodEnum<{
        PROGRAMS: string;
        REFERRAL: string;
        OBSOLETE: string;
        VITALS: string;
        SIMPLE_CHART: string;
        COMPLEX_CHART: string;
        COMPLEX_CHART_CORE: string;
    }>>>;
}, z.core.$strip>;
export type BaseSurvey = z.infer<typeof BaseSurveySchema>;
export declare const SurveyWithProgramSchema: z.ZodObject<{
    id: z.ZodString;
    code: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    name: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    surveyType: z.ZodOptional<z.ZodNullable<z.ZodEnum<{
        PROGRAMS: string;
        REFERRAL: string;
        OBSOLETE: string;
        VITALS: string;
        SIMPLE_CHART: string;
        COMPLEX_CHART: string;
        COMPLEX_CHART_CORE: string;
    }>>>;
    program: z.ZodObject<{
        id: z.ZodString;
        name: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        code: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    }, z.core.$strip>;
}, z.core.$strip>;
//# sourceMappingURL=survey.schema.d.ts.map