import { z } from 'zod';
export declare const AppointmentSchema: z.ZodObject<{
    id: z.ZodString;
    startTime: z.ZodString;
    endTime: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    status: z.ZodEnum<{
        CONFIRMED: string;
        ARRIVED: string;
        ASSESSED: string;
        SEEN: string;
        NO_SHOW: string;
        CANCELLED: string;
    }>;
    isHighPriority: z.ZodBoolean;
    appointmentType: z.ZodOptional<z.ZodNullable<z.ZodObject<{
        id: z.ZodString;
        name: z.ZodString;
        code: z.ZodString;
        type: z.ZodString;
    }, z.core.$strip>>>;
    locationGroup: z.ZodOptional<z.ZodNullable<z.ZodObject<{
        id: z.ZodString;
        name: z.ZodString;
        code: z.ZodString;
        facility: z.ZodObject<{
            id: z.ZodString;
            code: z.ZodString;
            name: z.ZodString;
        }, z.core.$strip>;
    }, z.core.$strip>>>;
    clinician: z.ZodOptional<z.ZodNullable<z.ZodObject<{
        id: z.ZodString;
        displayName: z.ZodString;
    }, z.core.$strip>>>;
}, z.core.$strip>;
export type Appointment = z.infer<typeof AppointmentSchema>;
//# sourceMappingURL=appointment.schema.d.ts.map