import React from 'react';
import { Document } from '@react-pdf/renderer';
import { replaceInTemplate } from '@tamanu/utils/replaceInTemplate';
import { Table } from './Table';
import { Box, Col, Row, styles, Watermark } from './Layout';
import { CovidLetterheadSection } from './CovidLetterheadSection';
import { CovidPatientDetailsSection } from './CovidPatientDetailsSection';
import { SigningSection } from './SigningSection';
import { H3, P } from './Typography';
import { getCompletedDate, getDateOfSwab, getLabMethod, getLaboratory, getRequestId, getTimeOfSwab } from './labRequestAccessors';
import { getDisplayDate } from './getDisplayDate';
import { withLanguageContext } from '../pdf/languageContext';
import { Page } from '../pdf/Page';
const columns = [
    {
        key: 'date-of-swab',
        title: 'Date of swab',
        accessor: getDateOfSwab
    },
    {
        key: 'time-of-swab',
        title: 'Time of swab',
        accessor: getTimeOfSwab
    },
    {
        key: 'date-of-test',
        title: 'Date of test',
        accessor: getCompletedDate
    },
    {
        key: 'laboratory',
        title: 'Laboratory',
        accessor: getLaboratory
    },
    {
        key: 'requestId',
        title: 'Request ID',
        accessor: getRequestId
    },
    {
        key: 'method',
        title: 'Method',
        accessor: getLabMethod
    },
    {
        key: 'result',
        title: 'Result',
        accessor: ({ result })=>result
    },
    {
        key: 'specimenType',
        title: 'Specimen type',
        accessor: ({ labTestType })=>(labTestType || {}).name || 'Unknown'
    }
];
export const CertificateTypes = {
    test: 'test',
    clearance: 'clearance'
};
const CertificateTitle = {
    test: 'Covid-19 Test History',
    clearance: 'Covid-19 Clearance Certificate'
};
const getCertificateRemark = (patient, getSetting)=>({
        test: '',
        clearance: replaceInTemplate(getSetting('templates.covidTestCertificate.clearanceCertRemark') ?? '', patient)
    });
const CovidLabCertificateComponent = ({ patient, labs, signingSrc, watermarkSrc, vdsSrc, logoSrc, getLocalisation, getSetting, printedBy, certType })=>/*#__PURE__*/ React.createElement(Document, null, /*#__PURE__*/ React.createElement(Page, {
        size: "A4",
        style: styles.page
    }, watermarkSrc && /*#__PURE__*/ React.createElement(Watermark, {
        src: watermarkSrc
    }), /*#__PURE__*/ React.createElement(CovidLetterheadSection, {
        getSetting: getSetting,
        logoSrc: logoSrc
    }), /*#__PURE__*/ React.createElement(Box, {
        mb: 0
    }, /*#__PURE__*/ React.createElement(H3, null, CertificateTitle[certType] || ''), /*#__PURE__*/ React.createElement(CovidPatientDetailsSection, {
        patient: patient,
        vdsSrc: vdsSrc,
        getLocalisation: getLocalisation,
        getSetting: getSetting
    })), /*#__PURE__*/ React.createElement(Box, {
        mb: 30
    }, /*#__PURE__*/ React.createElement(Table, {
        data: labs,
        columns: columns,
        getLocalisation: getLocalisation,
        getSetting: getSetting
    })), /*#__PURE__*/ React.createElement(P, null, getCertificateRemark(patient, getSetting)[certType] || ''), /*#__PURE__*/ React.createElement(Box, null), /*#__PURE__*/ React.createElement(Box, null, /*#__PURE__*/ React.createElement(Row, null, /*#__PURE__*/ React.createElement(Col, null, /*#__PURE__*/ React.createElement(P, null, "Printed by: ", printedBy)), /*#__PURE__*/ React.createElement(Col, null, /*#__PURE__*/ React.createElement(P, null, "Printing date: ", getDisplayDate(undefined, undefined, getLocalisation))))), /*#__PURE__*/ React.createElement(SigningSection, {
        signingSrc: signingSrc
    })));
export const CovidLabCertificate = withLanguageContext(CovidLabCertificateComponent);

//# sourceMappingURL=CovidLabCertificate.js.map