import type { Models, Sequelize } from '@tamanu/database';
import type { Logger } from 'winston';
export type At = ':start:' | ':end:';
export declare const START: At;
export declare const END: At;
export declare const MIGRATION_PREFIX = "migration/";
export declare const STEP_PREFIX = "upgrade/";
export type StepStr = `upgrade/${string}/${number}`;
export type MigrationStr = `migration/${string}`;
export type Need = StepStr | MigrationStr;
export type Needs = Need[];
export declare const needsStep: (step: string) => StepStr;
export declare const needsMigration: (mig: string) => MigrationStr;
export declare const onlySteps: (needs: Needs) => StepStr[];
export declare const onlyMigrations: (needs: Needs) => MigrationStr[];
export declare const stepFile: (str: StepStr) => string;
export declare const migrationFile: (str: MigrationStr) => string;
export interface StepArgs {
    sequelize: Sequelize;
    models: Models;
    log: Logger;
    fromVersion: string;
    toVersion: string;
    serverType: 'central' | 'facility';
}
export interface Step {
    at: At;
    before?: Needs;
    after?: Needs;
    check?: (args: StepArgs) => Promise<boolean>;
    run: (args: StepArgs) => Promise<void>;
}
export type Steps = Step[];
//# sourceMappingURL=step.d.ts.map