"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.applyEnhancedResolver = exports.isAssetFile = void 0;
const platform_1 = require("@rnx-kit/tools-react-native/platform");
const path = __importStar(require("path"));
const getEnhancedResolver = (() => {
    const resolvers = {};
    return (context, platform = "common") => {
        if (!resolvers[platform]) {
            const { mainFields, sourceExts, unstable_conditionNames, unstable_enablePackageExports, } = context;
            const extensions = sourceExts.map((ext) => `.${ext}`);
            resolvers[platform] = require("enhanced-resolve").create.sync({
                // Map Metro's `context.extraNodeModules` to Webpack's `resolve.alias`.
                // Metro's implementation is a subset of Webpack's. See:
                // - https://facebook.github.io/metro/docs/resolution
                // - https://webpack.js.org/configuration/resolve/#resolvealias
                alias: context.extraNodeModules,
                aliasFields: ["browser"],
                // Add `require` to handle packages that are missing `default`
                // conditional. See
                // https://github.com/webpack/enhanced-resolve/issues/313
                conditionNames: unstable_enablePackageExports
                    ? unstable_conditionNames
                    : ["require", "node"],
                // Unless `unstable_enablePackageExports` is enabled, disable exports
                // map as it currently takes precedence over the `react-native` field.
                ...(unstable_enablePackageExports ? undefined : { exportsFields: [] }),
                extensions: platform === "common"
                    ? extensions
                    : (0, platform_1.expandPlatformExtensions)(platform, extensions),
                mainFields,
            });
        }
        return resolvers[platform];
    };
})();
function getFromDir({ originModulePath }) {
    return originModulePath ? path.dirname(originModulePath) : process.cwd();
}
/**
 * Returns whether the file at specified path is an asset.
 */
function isAssetFile(context, filePath) {
    var _a;
    const assetExts = context.assetExts;
    if (assetExts) {
        for (const ext of assetExts) {
            if (filePath.endsWith(ext)) {
                const dot = filePath.length - ext.length - 1;
                if (filePath[dot] === ".") {
                    return true;
                }
            }
        }
        return false;
    }
    return Boolean((_a = context.isAssetFile) === null || _a === void 0 ? void 0 : _a.call(context, filePath));
}
exports.isAssetFile = isAssetFile;
/**
 * Resolve a file path as an asset. Returns the set of files found after
 * expanding asset resolutions (e.g. `icon@2x.png`).
 *
 * @see {@link https://github.com/facebook/metro/commit/6e6f36fd982b9226b7daafd1c942c7be32f9af40}
 */
function resolveAsset(context, filePath) {
    const dirPath = path.dirname(filePath);
    const extension = path.extname(filePath);
    const basename = path.basename(filePath, extension);
    if (!/@\d+(?:\.\d+)?x$/.test(basename)) {
        try {
            const assets = context.resolveAsset(dirPath, basename, extension);
            if (assets != null) {
                return {
                    type: "assetFiles",
                    filePaths: assets,
                };
            }
        }
        catch (e) {
            //
        }
    }
    return {
        type: "assetFiles",
        filePaths: [filePath],
    };
}
function applyEnhancedResolver(_resolve, context, moduleName, platform) {
    if (!platform) {
        return { type: "empty" };
    }
    const enhancedResolve = getEnhancedResolver(context, platform);
    const filePath = enhancedResolve(getFromDir(context), moduleName);
    if (filePath === false) {
        return { type: "empty" };
    }
    if (isAssetFile(context, moduleName)) {
        return resolveAsset(context, filePath);
    }
    return {
        type: "sourceFile",
        filePath,
    };
}
exports.applyEnhancedResolver = applyEnhancedResolver;
//# sourceMappingURL=enhancedResolve.js.map