"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.patchMetro = exports.shouldEnableRetryResolvingFromDisk = void 0;
const console_1 = require("@rnx-kit/console");
const metro_1 = require("@rnx-kit/tools-react-native/metro");
const fs = __importStar(require("fs"));
const path = __importStar(require("path"));
const url = __importStar(require("url"));
function fileExists(path) {
    const stat = fs.statSync(path, { throwIfNoEntry: false });
    return Boolean(stat && stat.isFile());
}
function importMetroModule(path) {
    const modulePath = (0, metro_1.findMetroPath)() + path;
    try {
        return require(modulePath);
    }
    catch (_) {
        throw new Error(`Cannot find '${modulePath}'. This probably means that ` +
            "'experimental_retryResolvingFromDisk' is not compatible with the " +
            "version of 'metro' that you are currently using. Please update to " +
            "the latest version and try again. If the issue still persists after " +
            "the update, please file a bug at " +
            "https://github.com/microsoft/rnx-kit/issues.");
    }
}
function supportsRetryResolvingFromDisk() {
    const { version } = importMetroModule("/package.json");
    const [major, minor] = version.split(".");
    const v = major * 1000 + minor;
    return v >= 64 && v <= 80;
}
function shouldEnableRetryResolvingFromDisk({ experimental_retryResolvingFromDisk, }) {
    if (experimental_retryResolvingFromDisk &&
        experimental_retryResolvingFromDisk !== "force" &&
        !supportsRetryResolvingFromDisk()) {
        (0, console_1.warn)("The version of Metro you're using has not been tested with " +
            "`experimental_retryResolvingFromDisk`. If you still want to enable " +
            "it, please set it to 'force'.");
        return false;
    }
    return Boolean(experimental_retryResolvingFromDisk);
}
exports.shouldEnableRetryResolvingFromDisk = shouldEnableRetryResolvingFromDisk;
/**
 * Monkey-patches Metro to not use HasteFS as the only source for module
 * resolution.
 *
 * Practically every file system operation in Metro must go through HasteFS,
 * most notably watching for file changes and resolving node modules. If Metro
 * cannot find a file in the Haste map, it does not exist. This means that for
 * Metro to find a file, all folders must be declared in `watchFolders`,
 * including `node_modules` and any dependency storage folders (e.g. pnpm)
 * regardless of whether we need to watch them. In big monorepos, this can
 * easily overwhelm file watchers, even with Watchman installed.
 *
 * There's no way to avoid the initial crawling of the file system. However, we
 * can drastically reduce the number of files that needs to be crawled/watched
 * by not relying solely on Haste for module resolution. This requires patching
 * Metro to use `fs.existsSync` instead of `HasteFS.exists`. With this change,
 * we can list only the folders that we care about in `watchFolders`. In some
 * cases, like on CI, we can even set `watchFolders` to an empty array to limit
 * watched files to the current package only.
 *
 * Why didn't we use `hasteImplModulePath`? Contrary to the name, it doesn't
 * let you replace HasteFS. As of 0.73, it is only used to retrieve the path of
 * a module. The default implementation returns
 * `path.relative(projectRoot, filePath)` if the entry is not found in the map.
 *
 * @param options Options passed to Metro
 */
function patchMetro(options) {
    if (!shouldEnableRetryResolvingFromDisk(options)) {
        return;
    }
    (0, console_1.info)(`experimental_retryResolvingFromDisk: Patching '${(0, metro_1.findMetroPath)()}'`);
    const DependencyGraph = importMetroModule("/src/node-haste/DependencyGraph");
    // Patch `_createModuleResolver` and `_doesFileExist` to use `fs.existsSync`.
    DependencyGraph.prototype.orig__createModuleResolver =
        DependencyGraph.prototype._createModuleResolver;
    DependencyGraph.prototype._createModuleResolver = function () {
        const hasteFS = this._fileSystem || // >= 0.73.5
            this._snapshotFS || // 0.73.4
            this._hasteFS; // < 0.73.4
        this._doesFileExist = (filePath) => {
            return hasteFS.exists(filePath) || fileExists(filePath);
        };
        this.orig__createModuleResolver();
        if (typeof this._moduleResolver._options.resolveAsset !== "function") {
            throw new Error("Could not find `resolveAsset` in `ModuleResolver`");
        }
        this._moduleResolver._options.resolveAsset = (dirPath, assetName, extension) => {
            const basePath = dirPath + path.sep + assetName;
            const assets = [
                basePath + extension,
                ...this._config.resolver.assetResolutions.map((resolution) => basePath + "@" + resolution + "x" + extension),
            ].filter(this._doesFileExist);
            return assets.length ? assets : null;
        };
    };
    // Since we will be resolving files outside of `watchFolders`, their hashes
    // will not be found. We'll return the `filePath` as they should be unique.
    DependencyGraph.prototype.orig_getSha1 = DependencyGraph.prototype.getSha1;
    DependencyGraph.prototype.getSha1 = function (filePath) {
        try {
            return this.orig_getSha1(filePath);
        }
        catch (e) {
            // `ReferenceError` will always be thrown when Metro encounters a file
            // that does not exist in the Haste map.
            if (e instanceof ReferenceError) {
                // Paths generated by pnpm setups include version numbers and/or hashes
                if (filePath.includes(".pnpm-store") || filePath.includes(".store")) {
                    return filePath;
                }
                const stat = fs.lstatSync(filePath);
                return filePath + "|" + stat.mtime.toISOString();
            }
            throw e;
        }
    };
    // We need to patch `_processSingleAssetRequest` because it calls
    // `Assets.getAsset`, and `Assets.getAsset` checks whether the asset lives
    // under one of `projectRoot` or `watchFolders`.
    const Server = importMetroModule("/src/Server");
    Server.prototype.orig__processSingleAssetRequest =
        Server.prototype._processSingleAssetRequest;
    Server.prototype._processSingleAssetRequest = function (req, res) {
        // eslint-disable-next-line node/no-deprecated-api
        const urlObj = url.parse(decodeURI(req.url), true);
        let [, assetPath] = (urlObj &&
            urlObj.pathname &&
            urlObj.pathname.match(/^\/assets\/(.+)$/)) ||
            [];
        if (!assetPath && urlObj && urlObj.query && urlObj.query.unstable_path) {
            const unstable_path = Array.isArray(urlObj.query.unstable_path)
                ? urlObj.query.unstable_path[0]
                : urlObj.query.unstable_path;
            const result = unstable_path.match(/^([^?]*)\??(.*)$/);
            if (result == null) {
                throw new Error(`Unable to parse URL: ${unstable_path}`);
            }
            const [, actualPath] = result;
            assetPath = actualPath;
        }
        if (!assetPath) {
            throw new Error(`Could not extract asset path from URL: ${req.url}`);
        }
        const watchFolders = this.getWatchFolders();
        const absolutePath = path.resolve(this._config.projectRoot, assetPath);
        this._config.watchFolders = [path.dirname(absolutePath)];
        try {
            return this.orig__processSingleAssetRequest(req, res);
        }
        finally {
            this._config.watchFolders = watchFolders;
        }
    };
}
exports.patchMetro = patchMetro;
//# sourceMappingURL=patchMetro.js.map