export const PATIENT_REGISTRY_TYPES = {
    NEW_PATIENT: 'new_patient',
    BIRTH_REGISTRY: 'birth_registry',
};
export const BIRTH_DELIVERY_TYPES = {
    NORMAL_VAGINAL_DELIVERY: 'normal_vaginal_delivery',
    BREECH: 'breech',
    EMERGENCY_C_SECTION: 'emergency_c_section',
    ELECTIVE_C_SECTION: 'elective_c_section',
    VACUUM_EXTRACTION: 'vacuum_extraction',
    FORCEPS: 'forceps',
    OTHER: 'other',
};
export const BIRTH_TYPES = {
    SINGLE: 'single',
    PLURAL: 'plural',
};
export const PLACE_OF_BIRTH_TYPES = {
    HEALTH_FACILITY: 'health_facility',
    HOME: 'home',
    OTHER: 'other',
};
export const ATTENDANT_OF_BIRTH_TYPES = {
    DOCTOR: 'doctor',
    MIDWIFE: 'midwife',
    NURSE: 'nurse',
    TRADITIONAL_BIRTH_ATTENDANT: 'traditional_birth_attentdant',
    OTHER: 'other',
};
export const ATTENDANT_OF_BIRTH_LABELS = {
    [ATTENDANT_OF_BIRTH_TYPES.DOCTOR]: 'Doctor',
    [ATTENDANT_OF_BIRTH_TYPES.MIDWIFE]: 'Midwife',
    [ATTENDANT_OF_BIRTH_TYPES.NURSE]: 'Nurse',
    [ATTENDANT_OF_BIRTH_TYPES.TRADITIONAL_BIRTH_ATTENDANT]: 'Traditional birth attendant',
    [ATTENDANT_OF_BIRTH_TYPES.OTHER]: 'Other',
};
export const ATTENDANT_OF_BIRTH_OPTIONS = [
    {
        value: ATTENDANT_OF_BIRTH_TYPES.DOCTOR,
        label: ATTENDANT_OF_BIRTH_LABELS[ATTENDANT_OF_BIRTH_TYPES.DOCTOR],
    },
    {
        value: ATTENDANT_OF_BIRTH_TYPES.MIDWIFE,
        label: ATTENDANT_OF_BIRTH_LABELS[ATTENDANT_OF_BIRTH_TYPES.MIDWIFE],
    },
    {
        value: ATTENDANT_OF_BIRTH_TYPES.NURSE,
        label: ATTENDANT_OF_BIRTH_LABELS[ATTENDANT_OF_BIRTH_TYPES.NURSE],
    },
    {
        value: ATTENDANT_OF_BIRTH_TYPES.TRADITIONAL_BIRTH_ATTENDANT,
        label: ATTENDANT_OF_BIRTH_LABELS[ATTENDANT_OF_BIRTH_TYPES.TRADITIONAL_BIRTH_ATTENDANT],
    },
    {
        value: ATTENDANT_OF_BIRTH_TYPES.OTHER,
        label: ATTENDANT_OF_BIRTH_LABELS[ATTENDANT_OF_BIRTH_TYPES.OTHER],
    },
];
export const BIRTH_DELIVERY_TYPE_LABELS = {
    [BIRTH_DELIVERY_TYPES.NORMAL_VAGINAL_DELIVERY]: 'Normal vaginal delivery',
    [BIRTH_DELIVERY_TYPES.BREECH]: 'Breech',
    [BIRTH_DELIVERY_TYPES.EMERGENCY_C_SECTION]: 'Emergency C-section',
    [BIRTH_DELIVERY_TYPES.ELECTIVE_C_SECTION]: 'Elective C-section',
    [BIRTH_DELIVERY_TYPES.VACUUM_EXTRACTION]: 'Vacuum extraction',
    [BIRTH_DELIVERY_TYPES.FORCEPS]: 'Forceps',
    [BIRTH_DELIVERY_TYPES.OTHER]: 'Other',
};
export const BIRTH_DELIVERY_TYPE_OPTIONS = [
    {
        value: BIRTH_DELIVERY_TYPES.NORMAL_VAGINAL_DELIVERY,
        label: BIRTH_DELIVERY_TYPE_LABELS[BIRTH_DELIVERY_TYPES.NORMAL_VAGINAL_DELIVERY],
    },
    {
        value: BIRTH_DELIVERY_TYPES.BREECH,
        label: BIRTH_DELIVERY_TYPE_LABELS[BIRTH_DELIVERY_TYPES.BREECH],
    },
    {
        value: BIRTH_DELIVERY_TYPES.EMERGENCY_C_SECTION,
        label: BIRTH_DELIVERY_TYPE_LABELS[BIRTH_DELIVERY_TYPES.EMERGENCY_C_SECTION],
    },
    {
        value: BIRTH_DELIVERY_TYPES.ELECTIVE_C_SECTION,
        label: BIRTH_DELIVERY_TYPE_LABELS[BIRTH_DELIVERY_TYPES.ELECTIVE_C_SECTION],
    },
    {
        value: BIRTH_DELIVERY_TYPES.VACUUM_EXTRACTION,
        label: BIRTH_DELIVERY_TYPE_LABELS[BIRTH_DELIVERY_TYPES.VACUUM_EXTRACTION],
    },
    {
        value: BIRTH_DELIVERY_TYPES.FORCEPS,
        label: BIRTH_DELIVERY_TYPE_LABELS[BIRTH_DELIVERY_TYPES.FORCEPS],
    },
    {
        value: BIRTH_DELIVERY_TYPES.OTHER,
        label: BIRTH_DELIVERY_TYPE_LABELS[BIRTH_DELIVERY_TYPES.OTHER],
    },
];
export const BIRTH_TYPE_LABELS = {
    [BIRTH_TYPES.SINGLE]: 'Single',
    [BIRTH_TYPES.PLURAL]: 'Plural',
};
export const BIRTH_TYPE_OPTIONS = [
    { value: BIRTH_TYPES.SINGLE, label: BIRTH_TYPE_LABELS[BIRTH_TYPES.SINGLE] },
    { value: BIRTH_TYPES.PLURAL, label: BIRTH_TYPE_LABELS[BIRTH_TYPES.PLURAL] },
];
export const PLACE_OF_BIRTH_LABELS = {
    [PLACE_OF_BIRTH_TYPES.HEALTH_FACILITY]: 'Health facility',
    [PLACE_OF_BIRTH_TYPES.HOME]: 'Home',
    [PLACE_OF_BIRTH_TYPES.OTHER]: 'Other',
};
export const PLACE_OF_BIRTH_OPTIONS = [
    {
        value: PLACE_OF_BIRTH_TYPES.HEALTH_FACILITY,
        label: PLACE_OF_BIRTH_LABELS[PLACE_OF_BIRTH_TYPES.HEALTH_FACILITY],
    },
    {
        value: PLACE_OF_BIRTH_TYPES.HOME,
        label: PLACE_OF_BIRTH_LABELS[PLACE_OF_BIRTH_TYPES.HOME],
    },
    {
        value: PLACE_OF_BIRTH_TYPES.OTHER,
        label: PLACE_OF_BIRTH_LABELS[PLACE_OF_BIRTH_TYPES.OTHER],
    },
];
