"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "default", {
    enumerable: true,
    get: function() {
        return _default;
    }
});
const Sequelize = require('sequelize');
const NOTE_RECORD_TYPE_VALUES = [
    'Encounter',
    'Patient',
    'Triage',
    'PatientCarePlan',
    'LabRequest',
    'ImagingRequest'
];
const _default = {
    up: async (query)=>{
        await query.changeColumn('notes', 'record_type', {
            type: Sequelize.STRING,
            allowNull: false
        });
    },
    down: async (query)=>{
        await query.sequelize.query('DROP TYPE "enum_notes_record_type"');
        await query.changeColumn('notes', 'record_type', {
            type: Sequelize.ENUM(NOTE_RECORD_TYPE_VALUES),
            allowNull: false
        });
    }
};

//# sourceMappingURL=048_changeNoteRecordTypeColumn.js.map