"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
async function up(query) {
    await query.createTable('sync_device_ticks', {
        id: {
            type: `BIGINT GENERATED ALWAYS AS ("persisted_at_sync_tick") STORED`
        },
        persisted_at_sync_tick: {
            primaryKey: true,
            type: _sequelize.DataTypes.BIGINT,
            allowNull: false
        },
        device_id: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: false
        }
    });
    await query.addIndex('sync_device_ticks', {
        fields: [
            'persisted_at_sync_tick'
        ]
    });
}
async function down(query) {
    await query.dropTable('sync_device_ticks');
}

//# sourceMappingURL=1727736021190-addSyncDeviceTicksTable.js.map