"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
async function up(query) {
    // Set deletedAt for historical records with registrationStatus = recordedInError
    // Use the date field value as deletedAt value, with proper timestamp conversion
    await query.sequelize.query(`
    UPDATE patient_program_registrations
    SET deleted_at = date::timestamp
    WHERE registration_status = 'recordedInError' AND deleted_at IS NULL
  `);
}
async function down(query) {
    // Revert the changes by setting deletedAt back to null
    await query.sequelize.query(`
    UPDATE patient_program_registrations
    SET deleted_at = NULL
    WHERE registration_status = 'recordedInError' and deleted_at = date::timestamp
  `);
}

//# sourceMappingURL=1744234388448-addPatientProgramRegistrationDeletedAt.js.map