"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _constants = require("@tamanu/constants");
async function up(query) {
    await query.sequelize.query(`UPDATE fhir.service_requests
     SET is_live = false
     WHERE id IN (
        SELECT sr.id FROM fhir.service_requests sr JOIN imaging_requests ir ON sr.upstream_id = ir.id
        WHERE 
          ir.status NOT IN (${_constants.IMAGING_TABLE_STATUS_GROUPINGS.ACTIVE.map((status)=>`'${status}'`).join(',')})
          AND sr.resolved = true
     )
    `);
    await query.sequelize.query(`UPDATE fhir.service_requests
     SET is_live = false
     WHERE id IN (
        SELECT sr.id FROM fhir.service_requests sr JOIN lab_requests lr ON sr.upstream_id = lr.id
        WHERE 
          lr.status NOT IN (${_constants.LAB_REQUEST_TABLE_STATUS_GROUPINGS.ACTIVE.map((status)=>`'${status}'`).join(',')})
          AND sr.resolved = true
     )
    `);
}
async function down() {
// There's no way to reverse this migration as we won't know the previous `is_live` state
// This should be fine as the `is_live` field will be recalculated on the next rematerialisation
}

//# sourceMappingURL=1744249774546-setIsLiveForFhirServiceRequests.js.map