"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
async function up(query) {
    await query.createTable('procedure_type_surveys', {
        id: {
            type: _sequelize.DataTypes.UUID,
            allowNull: false,
            primaryKey: true,
            defaultValue: _sequelize.Sequelize.fn('gen_random_uuid')
        },
        procedure_type_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false,
            references: {
                model: 'reference_data',
                key: 'id'
            }
        },
        survey_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false,
            references: {
                model: 'surveys',
                key: 'id'
            }
        },
        created_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: false,
            defaultValue: _sequelize.Sequelize.fn('now')
        },
        updated_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: false,
            defaultValue: _sequelize.Sequelize.fn('now')
        },
        deleted_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        }
    });
    await query.addConstraint('procedure_type_surveys', {
        fields: [
            'procedure_type_id',
            'survey_id'
        ],
        type: 'unique',
        name: 'procedure_type_survey_unique'
    });
}
async function down(query) {
    await query.dropTable('procedure_type_surveys');
}

//# sourceMappingURL=1750647407279-addProcedureTypeSurveysTable.js.map