"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const TABLES_FOR_REFRESH = [
    'pharmacy_orders',
    'pharmacy_order_prescriptions'
];
async function up(query) {
    for (const table of TABLES_FOR_REFRESH){
        await query.sequelize.query(`
      CREATE TRIGGER fhir_refresh
      AFTER INSERT OR UPDATE OR DELETE ON ${table}
      FOR EACH ROW EXECUTE FUNCTION fhir.refresh_trigger()
    `);
    }
}
async function down(query) {
    for (const table of TABLES_FOR_REFRESH){
        await query.sequelize.query(`DROP TRIGGER IF EXISTS fhir_refresh ON ${table}`);
    }
}

//# sourceMappingURL=1754033544110-AddMedicationRequestFhirTriggers.js.map