"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
const TABLE = {
    tableName: 'dhis2_pushes',
    schema: 'logs'
};
async function up(query) {
    await query.createTable(TABLE, {
        id: {
            type: _sequelize.DataTypes.UUID,
            allowNull: false,
            primaryKey: true,
            defaultValue: _sequelize.Sequelize.fn('uuid_generate_v4')
        },
        created_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: false
        },
        updated_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: false
        },
        deleted_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        },
        report_id: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: false
        },
        status: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: false
        },
        message: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: true
        },
        imported: {
            type: _sequelize.DataTypes.INTEGER,
            allowNull: true
        },
        updated: {
            type: _sequelize.DataTypes.INTEGER,
            allowNull: true
        },
        ignored: {
            type: _sequelize.DataTypes.INTEGER,
            allowNull: true
        },
        deleted: {
            type: _sequelize.DataTypes.INTEGER,
            allowNull: true
        },
        conflicts: {
            type: _sequelize.DataTypes.JSON,
            allowNull: true
        }
    });
    // Add foreign key constraint to report_definitions table in the public schema
    await query.addConstraint(TABLE, {
        fields: [
            'report_id'
        ],
        type: 'foreign key',
        name: 'dhis2_pushes_report_id_fkey',
        references: {
            table: {
                tableName: 'report_definitions',
                schema: 'public'
            },
            field: 'id'
        },
        onDelete: 'NO ACTION',
        onUpdate: 'NO ACTION'
    });
}
async function down(query) {
    await query.removeConstraint(TABLE, 'dhis2_pushes_report_id_fkey');
    await query.dropTable(TABLE);
}

//# sourceMappingURL=1757546138713-dhis2Logging.js.map