"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
const TABLE_NAME = 'medication_dispenses';
const ISO9075_DATE_TIME_FMT = 'YYYY-MM-DD HH24:MI:SS';
async function up(query) {
    await query.createTable(TABLE_NAME, {
        id: {
            type: _sequelize.DataTypes.UUID,
            primaryKey: true,
            defaultValue: _sequelize.Sequelize.fn('gen_random_uuid')
        },
        pharmacy_order_prescription_id: {
            type: _sequelize.DataTypes.UUID,
            allowNull: false,
            references: {
                model: 'pharmacy_order_prescriptions',
                key: 'id'
            }
        },
        quantity: {
            type: _sequelize.DataTypes.INTEGER,
            allowNull: false
        },
        instructions: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: true
        },
        dispensed_by_user_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false,
            references: {
                model: 'users',
                key: 'id'
            }
        },
        dispensed_at: {
            type: _sequelize.DataTypes.DATETIMESTRING,
            allowNull: false,
            defaultValue: _sequelize.Sequelize.fn('to_char', _sequelize.Sequelize.fn('current_timestamp', 3), ISO9075_DATE_TIME_FMT)
        },
        created_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: false,
            defaultValue: _sequelize.Sequelize.fn('now')
        },
        updated_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: false,
            defaultValue: _sequelize.Sequelize.fn('now')
        },
        deleted_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        }
    });
    await query.addIndex(TABLE_NAME, [
        'pharmacy_order_prescription_id'
    ], {
        name: 'idx_medication_dispenses_pharmacy_order_prescription_id'
    });
}
async function down(query) {
    await query.dropTable(TABLE_NAME);
}

//# sourceMappingURL=1765793625551-createMedicationDispensesTable.js.map