"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "ReferenceDrugFacility", {
    enumerable: true,
    get: function() {
        return ReferenceDrugFacility;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
const _buildSyncLookupSelect = require("../sync/buildSyncLookupSelect");
let ReferenceDrugFacility = class ReferenceDrugFacility extends _Model.Model {
    static initModel(options) {
        super.init({
            id: {
                type: `TEXT GENERATED ALWAYS AS (REPLACE("reference_drug_id", ';', ':') || ';' || REPLACE("facility_id", ';', ':')) STORED`,
                set () {
                // any sets of the convenience generated "id" field can be ignored
                }
            },
            referenceDrugId: {
                type: _sequelize.DataTypes.UUID,
                allowNull: false,
                primaryKey: true,
                references: {
                    model: 'referenceDrugs',
                    key: 'id'
                }
            },
            facilityId: {
                type: _sequelize.DataTypes.STRING,
                allowNull: false,
                primaryKey: true,
                references: {
                    model: 'facilities',
                    key: 'id'
                }
            },
            quantity: {
                type: _sequelize.DataTypes.INTEGER,
                allowNull: true
            },
            stockStatus: {
                type: _sequelize.DataTypes.STRING,
                allowNull: false,
                defaultValue: _constants.DRUG_STOCK_STATUSES.UNKNOWN
            }
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.PULL_FROM_CENTRAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.ReferenceDrug, {
            foreignKey: 'referenceDrugId',
            as: 'referenceDrug'
        });
        this.belongsTo(models.Facility, {
            foreignKey: 'facilityId',
            as: 'facility'
        });
    }
    static buildSyncFilter() {
        return `WHERE ${this.tableName}.facility_id IN (:facilityIds) AND ${this.tableName}.updated_at_sync_tick > :since`;
    }
    static async buildSyncLookupQueryDetails() {
        return {
            select: await (0, _buildSyncLookupSelect.buildSyncLookupSelect)(this, {
                facilityId: `${this.tableName}.facility_id`
            }),
            joins: ''
        };
    }
};

//# sourceMappingURL=ReferenceDrugFacility.js.map