import { Model } from './Model';
import type { InitOptions, ModelProperties, Models } from '../types/model';
import type { SessionConfig } from '../types/sync';
import type { User } from './User';
export declare class SurveyResponseAnswer extends Model {
    id: string;
    name?: string;
    body?: string;
    dataElementId?: string;
    responseId?: string;
    static initModel({ primaryKey, ...options }: InitOptions): void;
    static initRelations(models: Models): void;
    static buildPatientSyncFilter(patientCount: number, markedForSyncPatientsTable: string, sessionConfig: SessionConfig): string | null;
    static buildSyncLookupQueryDetails(): Promise<{
        select: string;
        joins: string;
    }>;
    static getDefaultId: (resource: string, settings: {
        get: (_arg0: string) => any;
    }) => Promise<any>;
    upsertCalculatedQuestions(data: {
        date: string;
        reasonForChange: string;
        user: ModelProperties<User>;
        isVital: boolean;
    }): Promise<this>;
    updateWithReasonForChange(newValue: string, reasonForChange: string): Promise<this>;
}
//# sourceMappingURL=SurveyResponseAnswer.d.ts.map