import { type InitOptions } from 'sequelize';
import { FhirResource } from './Resource';
import type { Models } from '../../types/model';
export declare class FhirPatient extends FhirResource {
    extension?: Record<string, any>;
    identifier?: Record<string, any>;
    active: boolean;
    name?: Record<string, any>;
    telecom?: Record<string, any>;
    gender: string;
    birthDate?: string;
    deceasedDateTime?: string;
    address?: Record<string, any>;
    link?: Record<string, any>;
    static initModel(options: InitOptions, models: Models): void;
    static CAN_DO: Set<string>;
    updateMaterialisation(): Promise<void>;
    getRelatedUpstreamIds(): Promise<string[]>;
    static queryToFindUpstreamIdsFromTable(upstreamTable: string, table: string, id: string, deletedRow?: null): Promise<{
        where: {
            id: string;
        };
        include?: undefined;
    } | {
        include: {
            model: typeof import("..").PatientAdditionalData;
            as: string;
            required: boolean;
            where: {
                id: string;
            };
        }[];
        where?: undefined;
    } | null>;
    asFhir(): Record<string, any>;
    static searchParameters(): {
        identifier: {
            type: string;
            path: string[][];
            tokenType: string;
        };
        given: {
            type: string;
            path: string[][];
        };
        family: {
            type: string;
            path: string[][];
        };
        gender: {
            type: string;
            path: string[][];
            sortable: boolean;
            tokenType: string;
        };
        birthdate: {
            type: string;
            path: string[][];
            datePrecision: string;
        };
        address: {
            type: string;
            path: string[][];
        };
        'address-city': {
            type: string;
            path: string[][];
        };
        telecom: {
            type: string;
            path: string[][];
            tokenType: string;
        };
        deceased: {
            type: string;
            path: string[][];
            tokenType: string;
        };
        active: {
            type: string;
            path: string[][];
            tokenType: string;
        };
        link: {
            type: string;
            path: string[][];
            referenceTypes: string[];
        };
    };
}
//# sourceMappingURL=FhirPatient.d.ts.map