"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "checkIsMigrationContextAvailable", {
    enumerable: true,
    get: function() {
        return checkIsMigrationContextAvailable;
    }
});
const checkIsMigrationContextAvailable = async (sequelize, migrationName)=>{
    const [result] = await sequelize.query(`
    SELECT COUNT(*) as count
    FROM pg_proc p
    JOIN pg_namespace n ON p.pronamespace = n.oid
    WHERE n.nspname = 'public'
    AND p.proname IN ('get_session_config', 'set_session_config');
  `);
    const count = parseInt(result[0].count, 10);
    return count === 2 && !migrationName.includes('1739969510355-sessionConfigFunctions');
};

//# sourceMappingURL=checkIsMigrationContextAvailable.js.map