function _define_property(obj, key, value) {
    if (key in obj) {
        Object.defineProperty(obj, key, {
            value: value,
            enumerable: true,
            configurable: true,
            writable: true
        });
    } else {
        obj[key] = value;
    }
    return obj;
}
import { DataMigration } from './DataMigration';
/*
 * CursorDataMigration is for SQL data migrations that can return the id of the
 * last modified record. The user inherits from it and defines a query that
 * takes `fromId` and returns `maxId`, as well as (optionally) initialising
 * `lastMaxId`.
 */ export class CursorDataMigration extends DataMigration {
    async doBatch(limit) {
        const { lastMaxId, log, store: { sequelize } } = this;
        this.started = true;
        log.debug('CursorDataMigration batch started', {
            lastMaxId
        });
        const [[{ maxId }], { rowCount }] = await sequelize.query(await this.getQuery(), {
            bind: {
                fromId: lastMaxId,
                limit
            }
        });
        log.debug('CursorDataMigration batch done', {
            lastMaxId,
            maxId
        });
        this.lastMaxId = maxId;
        return rowCount;
    }
    isComplete() {
        return Boolean(this.started && !this.lastMaxId);
    }
    async getQuery() {
        throw new Error('you should extend getQuery');
    }
    constructor(...args){
        super(...args), _define_property(this, "lastMaxId", null), _define_property(this, "started", false);
        if (this.constructor === CursorDataMigration) {
            throw new Error('CursorDataMigration is abstract');
        }
    }
}

//# sourceMappingURL=CursorDataMigration.js.map