import { Model } from '../Model';
import { type InitOptions, type ModelProperties, type Models } from '../../types/model';
import type { SessionConfig } from '../../types/sync';
import type { LabTest } from '../LabTest';
import type { ReferenceData } from '../ReferenceData';
import type { Encounter } from '../Encounter';
import type { User } from '../User';
import type { Note } from '../Note';
import type { LabTestPanelRequest } from '../LabTestPanelRequest';
interface LabRequestData {
    labTestTypeIds?: string[];
    labTestPanelId?: string;
    userId: string;
}
export declare class LabRequest extends Model {
    id: string;
    sampleTime?: string;
    requestedDate: string;
    specimenAttached: boolean;
    urgent: boolean;
    status: string;
    reasonForCancellation?: string;
    senaiteId?: string;
    sampleId?: string;
    displayId: string;
    publishedDate?: string;
    resultsInterpretation?: string;
    encounterId?: string;
    departmentId?: string;
    requestedById?: string;
    collectedById?: string;
    labTestCategoryId?: string;
    labSampleSiteId?: string;
    labTestPriorityId?: string;
    labTestLaboratoryId?: string;
    specimenTypeId?: string;
    labTestPanelRequestId?: string;
    priority?: ReferenceData;
    tests: LabTest[];
    encounter?: Encounter;
    requestedBy?: User;
    notes: Note[];
    labTestPanelRequest?: LabTestPanelRequest;
    static initModel({ primaryKey, ...options }: InitOptions): void;
    static createWithTests(data: LabRequestData & ModelProperties<LabRequest> & {
        labTest: ModelProperties<LabTest>;
    }): Promise<LabRequest>;
    static initRelations(models: Models): void;
    static getListReferenceAssociations(): (string | {
        association: string;
        include: string[];
    })[];
    static buildPatientSyncFilter(patientCount: number, markedForSyncPatientsTable: string, sessionConfig: SessionConfig): string | null;
    static buildSyncLookupQueryDetails(): Promise<{
        select: string;
        joins: string;
    }>;
    getTests(): Promise<LabTest[]>;
    getLatestAttachment(): Promise<import("..").LabRequestAttachment | null>;
}
export {};
//# sourceMappingURL=LabRequest.d.ts.map