import { type FindOptions } from 'sequelize';
import { COMMUNICATION_STATUSES_VALUES, PATIENT_COMMUNICATION_CHANNELS_VALUES, PATIENT_COMMUNICATION_TYPES_VALUES } from '@tamanu/constants';
import { Model } from './Model';
import type { InitOptions, Models } from '../types/model';
export declare class PatientCommunication extends Model {
    id: string;
    type: (typeof PATIENT_COMMUNICATION_TYPES_VALUES)[number];
    channel: (typeof PATIENT_COMMUNICATION_CHANNELS_VALUES)[number];
    subject?: string;
    content?: string;
    status: (typeof COMMUNICATION_STATUSES_VALUES)[number];
    error?: string;
    retryCount?: number;
    destination?: string;
    attachment?: string;
    hash?: number;
    patientId?: string;
    static initModel({ primaryKey, ...options }: InitOptions): void;
    static initRelations(models: Models): void;
    static getBaseQueryPendingMessage(channel: InstanceType<typeof PatientCommunication>['channel']): {
        where: {
            [x: symbol]: ({
                retryCount: {
                    [x: symbol]: any;
                };
            } | {
                retryCount: null;
            })[];
            status: string;
            channel: string;
        };
    };
    static getPendingMessages(channel: InstanceType<typeof PatientCommunication>['channel'], queryOptions: FindOptions<any> | undefined): Promise<PatientCommunication[]>;
    static countPendingMessages(channel: InstanceType<typeof PatientCommunication>['channel']): Promise<number>;
}
//# sourceMappingURL=PatientCommunication.d.ts.map