function _define_property(obj, key, value) {
    if (key in obj) {
        Object.defineProperty(obj, key, {
            value: value,
            enumerable: true,
            configurable: true,
            writable: true
        });
    } else {
        obj[key] = value;
    }
    return obj;
}
import { DataTypes } from 'sequelize';
import { FHIR_INTERACTIONS } from '@tamanu/constants';
import { FhirResource } from './Resource';
import { PharmacyOrderPrescription } from '../../models';
import { getQueryToFindUpstreamIds, getValues, searchParameters } from '../../utils/fhir/MedicationRequest';
export class FhirMedicationRequest extends FhirResource {
    static initModel(options, models) {
        super.initResource({
            identifier: DataTypes.JSONB,
            status: {
                type: DataTypes.TEXT,
                allowNull: false
            },
            intent: {
                type: DataTypes.TEXT,
                allowNull: false
            },
            groupIdentifier: DataTypes.JSONB,
            category: DataTypes.JSONB,
            subject: DataTypes.JSONB,
            encounter: DataTypes.JSONB,
            medication: DataTypes.JSONB,
            authoredOn: DataTypes.DATE,
            requester: DataTypes.JSONB,
            recorder: DataTypes.JSONB,
            note: DataTypes.JSONB,
            dosageInstruction: DataTypes.JSONB,
            dispenseRequest: DataTypes.JSONB
        }, options);
        this.UpstreamModels = [
            models.PharmacyOrderPrescription
        ];
        this.upstreams = [
            models.PharmacyOrderPrescription,
            models.PharmacyOrder,
            models.Prescription,
            models.Encounter,
            models.Patient,
            models.User,
            models.ReferenceData,
            models.Facility
        ];
        this.referencedResources = [
            models.FhirPatient,
            models.FhirOrganization,
            models.FhirEncounter,
            models.FhirPractitioner
        ];
    }
    async updateMaterialisation() {
        const upstream = await this.getUpstream();
        if (!upstream) {
            throw new Error(`No upstream pharmacy_order_prescription found for medication_request: ${this.id}`);
        }
        const values = await getValues(upstream, this.sequelize.models);
        this.set(values);
    }
    static async queryToFindUpstreamIdsFromTable(upstreamTable, table, id) {
        if (upstreamTable === PharmacyOrderPrescription.tableName) {
            return getQueryToFindUpstreamIds(this.sequelize.models, table, id);
        }
        return null;
    }
    static searchParameters() {
        return {
            ...super.searchParameters(),
            ...searchParameters
        };
    }
}
_define_property(FhirMedicationRequest, "CAN_DO", new Set([
    FHIR_INTERACTIONS.INSTANCE.READ,
    FHIR_INTERACTIONS.TYPE.SEARCH,
    FHIR_INTERACTIONS.INTERNAL.MATERIALISE
]));

//# sourceMappingURL=FhirMedicationRequest.js.map