"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "MerlinProvider", {
    enumerable: true,
    get: function() {
        return MerlinProvider;
    }
});
const _Provider = require("./Provider");
let MerlinProvider = class MerlinProvider extends _Provider.Provider {
    async getUrlForResult(result) {
        const { Encounter, Patient } = this.models;
        const { externalCode } = result;
        if (!externalCode) return null;
        const request = await result.getRequest({
            include: [
                {
                    model: Encounter,
                    as: 'encounter',
                    include: [
                        {
                            model: Patient,
                            as: 'patient'
                        }
                    ]
                }
            ]
        });
        const { patient } = request.encounter;
        const { urlgen, auth: { username, password }, patientId: { type, field } } = this.config;
        const url = new URL(urlgen);
        url.searchParams.set('accession', externalCode);
        url.searchParams.set('patIdType', type);
        url.searchParams.set('patId', patient[field]);
        const res = await fetch(url, {
            headers: {
                Authorization: `Basic ${Buffer.from(`${username}:${password}`).toString('base64')}`
            }
        });
        return res.text();
    }
};

//# sourceMappingURL=MerlinProvider.js.map