"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "patientFieldDefinition", {
    enumerable: true,
    get: function() {
        return patientFieldDefinition;
    }
});
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _sequelize = require("sequelize");
const _importable = require("@tamanu/constants/importable");
const _crudHelpers = require("@tamanu/shared/utils/crudHelpers");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const patientFieldDefinition = (0, _crudHelpers.permissionCheckingRouter)('read', 'Patient');
patientFieldDefinition.get('/$', (0, _expressasynchandler.default)(async (req, res)=>{
    const values = await req.db.query(`
        SELECT
          d.id AS "definitionId",
          d.name,
          d.field_type AS "fieldType",
          d.options,
          c.id As "categoryId",
          c.name AS category
        FROM patient_field_definitions d
        LEFT JOIN patient_field_definition_categories c
          ON d.category_id = c.id
        WHERE d.visibility_status NOT IN (:hiddenStatuses)
        AND d.deleted_at IS NULL
        AND c.deleted_at IS NULL
        ORDER BY category ASC, name ASC;
      `, {
        replacements: {
            hiddenStatuses: _importable.HIDDEN_VISIBILITY_STATUSES
        },
        type: _sequelize.QueryTypes.SELECT
    });
    res.send({
        count: values.length,
        data: values
    });
}));

//# sourceMappingURL=patientFieldDefinition.js.map